#include<bits/stdc++.h>

using namespace std;

void Putevi(int n, int m, int Q, int* U, int* V, int* W, int* X, int* Y, int* Ans) {
  if (m == n - 1) {
    vector<vector<int>> g(n);
    for (int i = 1; i <= m; i++) {
      --U[i]; --V[i];
      g[U[i]].push_back(V[i]);
      g[V[i]].push_back(U[i]);
    }
    const int L = 20;
    vector<vector<int>> jump(n, vector<int>(L));
    vector<int> dep(n);

    function<void(int, int)> Dfs = [&](int v, int pv) {
      dep[v] = dep[pv] + 1;
      jump[v][0] = pv;
      for (int i = 1; i < L; i++) {
        jump[v][i] = jump[jump[v][i - 1]][i - 1];
      }
      for (int u : g[v]) {
        if (u == pv) {
          continue;
        }
        Dfs(u, v);
      }
    };
    Dfs(0, 0);
    auto LCA = [&](int x, int y) {
      if (dep[x] < dep[y]) {
        swap(x, y);
      }
      for (int i = L - 1; i >= 0; i--) {
        if (dep[jump[x][i]] >= dep[y]) {
          x = jump[x][i];
        }
      }
      if (x == y) {
        return x;
      }
      for (int i = L - 1; i >= 0; i--) {
        if (jump[x][i] != jump[y][i]) {
          x = jump[x][i];
          y = jump[y][i];
        }
      }
      return jump[x][0];
    };
    for (int i = 1; i <= Q; i++) {
      --X[i]; --Y[i];
      Ans[i] = dep[LCA(X[i], Y[i])];
    }
    return;
  }
  vector<vector<pair<int, int>>> g(n);
  for (int i = 1; i <= m; i++) {
    --U[i]; --V[i];
    g[U[i]].emplace_back(V[i], W[i]);
    g[V[i]].emplace_back(U[i], W[i]);
  }
  const long long inf = (long long) 1e18;
  vector<long long> dist(n);
  auto Dijkstra = [&](int del) {
    for (int i = 0; i < n; i++) {
      dist[i] = inf;
    }
    set<pair<long long, int>> st;
    dist[0] = 0;
    st.emplace(0, 0);
    while (!st.empty()) {
      auto it = st.begin();
      int i = it->second;
      st.erase(it);
      for (auto& e : g[i]) {
        int to = e.first;
        int w = e.second;
        if (to == del) {
          continue;
        }
        if (dist[to] > dist[i] + w) {
          if (dist[to] != inf) {
            st.erase({dist[to], to});
          }
          dist[to] = dist[i] + w;
          st.emplace(dist[to], to);
        }
      }
    }
  };
  Dijkstra(-1);
  auto d = dist;
  vector<vector<int>> my(n);
  for (int i = 0; i < n; i++) {
    my[i].push_back(0);
  }
  for (int v = 1; v < n; v++) {
    Dijkstra(v);
    for (int i = 0; i < n; i++) {
      if (dist[i] != d[i]) {
        my[i].push_back(v);
      }
    }
  }
  vector<vector<bool>> has(n, vector<bool>(n));
  for (int i = 0; i < n; i++) {
    for (int j : my[i]) {
      has[i][j] = true;
    }
  }
  vector<vector<int>> res(n, vector<int>(n));
  vector<vector<bool>> seen(n, vector<bool>(n));
  for (int i = 1; i <= Q; i++) {
    --X[i]; --Y[i];
    if (X[i] > Y[i]) {
      swap(X[i], Y[i]);
    }
    if ((int) my[X[i]].size() > (int) my[Y[i]].size()) {
      swap(X[i], Y[i]);
    }
    if (seen[X[i]][Y[i]]) {
      Ans[i] = res[X[i]][Y[i]];
      continue;
    }
    int total = 0;
    for (int j : my[X[i]]) {
      if (has[Y[i]][j]) {
        total += 1;
      }
    }
    Ans[i] = total;
    res[X[i]][Y[i]] = total;
    seen[X[i]][Y[i]] = true;
  }
}

/*
4 5 3
1 2 2
2 3 3
2 4 5
1 3 5
4 3 4
2 4
3 4
2 2
*/